* Title: 	table1.do
* Version: 	23 May 2018
* Purpose: 	Produce Table 1 regressions 


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table1, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip conspuma RegionI PrimeMaleD EducationI ///
	EmpB UnempB LTJoblessB IndustryI incwage_real_ftfy_pos perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Keep only 1980/1990/2000 Census and 2009-2011 ACS
keep if year == 1980 | year == 1990 | year == 2000 | (year>=2009 & year<=2011)

* Pool data for 2009-2011 ACS
replace year = 2010 if year>=2009 & year<=2011

* Fix coding due to post-2006 PUMA change due to Katrina
replace conspuma = 172 if conspuma == 173


*******************************************************************************
* (2) Construct variables for 1980 education/industry shares
*******************************************************************************

preserve
keep if year==1980

gen LessHSEd 	= (EducationI == 1)
gen CollegeEd	= (EducationI == 4)

gen NondurableMan	= (IndustryI == 3)
gen DurableMan 		= (IndustryI == 4)
 
collapse	(sum) 	Total = PrimeMaleD Emp = EmpB ///
					LessHSEd CollegeEd ///
					NondurableMan DurableMan ///
			[pw=perwt], by(conspuma)

foreach var of varlist LessHSEd CollegeEd {
	gen double `var'_Rate_80 = `var'/Total
}
foreach var of varlist NondurableMan DurableMan {
	gen double `var'_Frac_80 = `var'/Emp
}

keep conspuma *_Rate_80 *_Frac_80
tempfile 1980
save `1980'
restore

*******************************************************************************
* (3) Construct variables for 2010 joblessness/median income
*******************************************************************************

keep if year==2010
collapse	(sum)   	Total = PrimeMaleD  ///
						Jobless = UnempB ///
			(median) 	Wage_Median_Real_2010 = incwage_real_ftfy_pos /// 
			[pw=perwt], by(conspuma RegionI statefip)
gen double Jobless_Rate_2010 = Jobless / Total

			
*******************************************************************************
* (4) Merge with 1980 shares and state-level temperature data
*******************************************************************************

* 1980 education/industry shares
merge m:1 conspuma using `1980', assert(matched) nogen

* Temperature data
merge m:1 statefip using dta/temperature, assert(matched using) keep(matched) nogen

* Save dataset
save output/tables/dta/table1.dta, replace


*******************************************************************************
* (5) Regressions
*******************************************************************************

* Column 1: 2010 jobless rate, education controls
reg Jobless_Rate_2010 CollegeEd_Rate LessHSEd_Rate, vce(cluster statefip)

* Column 2: 2010 jobless rate, education/industry controls
reg Jobless_Rate_2010 CollegeEd_Rate LessHSEd_Rate DurableMan_Frac NondurableMan_Frac, vce(cluster statefip)

* Column 3: 2010 jobless rate, education/industry/temperature controls
reg Jobless_Rate_2010 CollegeEd_Rate LessHSEd_Rate DurableMan_Frac NondurableMan_Frac Winter_Temp Summer_Temp, vce(cluster statefip)

* Column 4: 2010 median wage income, education controls
reg Wage_Median_Real_2010 CollegeEd_Rate LessHSEd_Rate, vce(cluster statefip)

* Column 5: 2010 median wage income, education/industry controls
reg Wage_Median_Real_2010 CollegeEd_Rate LessHSEd_Rate DurableMan_Frac NondurableMan_Frac, vce(cluster statefip)

* Column 6: 2010 median wage income, education/industry/temperature controls
reg Wage_Median_Real_2010 CollegeEd_Rate LessHSEd_Rate DurableMan_Frac NondurableMan_Frac Winter_Temp Summer_Temp, vce(cluster statefip)


*******************************************************************************
* (6) End of file
*******************************************************************************

log close
exit, clear
